/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.shapes;

import net.jayjay.dangerzone.shapes.Vertex;
import org.lwjgl.opengl.GL11;

public class Polygon {
    public Vertex[] vertices;
    public int vertexCount = 0;

    public Polygon(Vertex[] vertices) {
        this.vertices = vertices;
        this.vertexCount = vertices.length;
    }

    public Polygon(Vertex[] vertices, int u0, int v0, int u1, int v1) {
        this(vertices);
        vertices[0] = vertices[0].remap(u1, v0);
        vertices[1] = vertices[1].remap(u0, v0);
        vertices[2] = vertices[2].remap(u0, v1);
        vertices[3] = vertices[3].remap(u1, v1);
    }

    public Polygon(Vertex[] vertices, double u0, double v0, double u1, double v1) {
        this(vertices);
        vertices[0] = vertices[0].remap(u1, v0);
        vertices[1] = vertices[1].remap(u0, v0);
        vertices[2] = vertices[2].remap(u0, v1);
        vertices[3] = vertices[3].remap(u1, v1);
    }

    public void render() {
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        int i2 = 3;
        while (i2 >= 0) {
            Vertex v = this.vertices[i2];
            GL11.glNormal3d(v.nx, v.ny, v.nz);
            GL11.glTexCoord2d(v.u / 63.999, v.v / 31.999);
            GL11.glVertex3d(v.pos.x, v.pos.y, v.pos.z);
            --i2;
        }
    }
}

